/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.mixinextras.sugar.impl;

import club.sk1er.mods.scrollabletooltips.mixinextras.injector.StackExtension;
import club.sk1er.mods.scrollabletooltips.mixinextras.sugar.impl.SugarApplicationException;
import club.sk1er.mods.scrollabletooltips.mixinextras.sugar.impl.SugarApplicator;
import club.sk1er.mods.scrollabletooltips.mixinextras.sugar.impl.SugarParameter;
import club.sk1er.mods.scrollabletooltips.mixinextras.sugar.impl.SugarPostProcessingExtension;
import club.sk1er.mods.scrollabletooltips.mixinextras.sugar.impl.ref.LocalRefClassGenerator;
import club.sk1er.mods.scrollabletooltips.mixinextras.sugar.impl.ref.LocalRefUtils;
import club.sk1er.mods.scrollabletooltips.mixinextras.utils.InjectorUtils;
import java.util.HashMap;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.modify.InvalidImplicitDiscriminatorException;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;

class LocalSugarApplicator
extends SugarApplicator {
    private final boolean isArgsOnly;
    private final Type targetLocalType;
    private final boolean isMutable;

    LocalSugarApplicator(InjectionInfo info, SugarParameter parameter) {
        super(info, parameter);
        this.targetLocalType = LocalRefUtils.getTargetType(this.paramType, this.paramGeneric);
        this.isMutable = this.targetLocalType != this.paramType;
        this.isArgsOnly = (Boolean)Annotations.getValue((AnnotationNode)this.sugar, (String)"argsOnly", (Object)false);
    }

    @Override
    void validate(Target target, InjectionNodes.InjectionNode node2) {
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.sugar);
        LocalVariableDiscriminator.Context context = InjectorUtils.getOrCreateLocalContext(target, node2, this.info, this.targetLocalType, this.isArgsOnly);
        if (discriminator.printLVT()) {
            InjectorUtils.printLocals(target, node2.getCurrentTarget(), context, discriminator, this.targetLocalType, this.isArgsOnly);
            this.info.addCallbackInvocation(this.info.getMethod());
            throw new SugarApplicationException("Application aborted because locals are being printed instead.");
        }
        try {
            if (discriminator.findLocal(context) < 0) {
                throw new SugarApplicationException("Unable to find matching local!");
            }
        }
        catch (InvalidImplicitDiscriminatorException e) {
            throw new SugarApplicationException("Invalid implicit variable discriminator: ", e);
        }
    }

    @Override
    void prepare(Target target, InjectionNodes.InjectionNode node2) {
        InjectorUtils.getOrCreateLocalContext(target, node2, this.info, this.targetLocalType, this.isArgsOnly);
    }

    @Override
    void inject(Target target, InjectionNodes.InjectionNode node2, StackExtension stack) {
        LocalVariableDiscriminator.Context context;
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.sugar);
        int index = discriminator.findLocal(context = InjectorUtils.getOrCreateLocalContext(target, node2, this.info, this.targetLocalType, this.isArgsOnly));
        if (index < 0) {
            throw new SugarApplicationException("Failed to match a local, this should have been caught during validation.");
        }
        if (this.isMutable) {
            this.initAndLoadLocalRef(target, node2, index, stack);
        } else {
            stack.extra(this.targetLocalType.getSize());
            target.insns.insertBefore(node2.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(21), index));
        }
    }

    @Override
    int postProcessingPriority() {
        return 1000;
    }

    private void initAndLoadLocalRef(Target target, InjectionNodes.InjectionNode node2, int index, StackExtension stack) {
        String refName = LocalRefClassGenerator.getForType(this.targetLocalType);
        int refIndex = this.getOrCreateRef(target, node2, index, refName, stack);
        stack.extra(1);
        target.insns.insertBefore(node2.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(25, refIndex));
    }

    private int getOrCreateRef(Target target, InjectionNodes.InjectionNode node2, int index, String refImpl, StackExtension stack) {
        HashMap<Integer, Integer> refIndices = (HashMap<Integer, Integer>)node2.getDecoration("mixinextras_localRefMap");
        if (refIndices == null) {
            refIndices = new HashMap<Integer, Integer>();
            node2.decorate("mixinextras_localRefMap", refIndices);
        }
        if (refIndices.containsKey(index)) {
            return (Integer)refIndices.get(index);
        }
        int refIndex = target.allocateLocal();
        target.addLocalVariable(refIndex, "ref" + refIndex, 'L' + refImpl + ';');
        InsnList construction = new InsnList();
        LocalRefUtils.generateNew(construction, this.targetLocalType);
        construction.add((AbstractInsnNode)new VarInsnNode(58, refIndex));
        target.insertBefore(node2, construction);
        SugarPostProcessingExtension.enqueuePostProcessing(this, () -> {
            InsnList initialization = new InsnList();
            initialization.add((AbstractInsnNode)new VarInsnNode(25, refIndex));
            initialization.add((AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(21), index));
            LocalRefUtils.generateInitialization(initialization, this.targetLocalType);
            target.insertBefore(node2, initialization);
            InsnList after = new InsnList();
            after.add((AbstractInsnNode)new VarInsnNode(25, refIndex));
            LocalRefUtils.generateDisposal(after, this.targetLocalType);
            after.add((AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(54), index));
            target.insns.insert(node2.getCurrentTarget(), after);
        });
        stack.extra(this.targetLocalType.getSize() + 1);
        refIndices.put(index, refIndex);
        return refIndex;
    }
}

